/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.payloads.PayloadHelper;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class TokenOffsetPayloadTokenFilter
extends TokenFilter {
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PayloadAttribute payAtt = this.addAttribute(PayloadAttribute.class);

    public TokenOffsetPayloadTokenFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            byte[] data = new byte[8];
            PayloadHelper.encodeInt(this.offsetAtt.startOffset(), data, 0);
            PayloadHelper.encodeInt(this.offsetAtt.endOffset(), data, 4);
            BytesRef payload = new BytesRef(data);
            this.payAtt.setPayload(payload);
            return true;
        }
        return false;
    }
}

